

uniform float u_Elapsed;
uniform vec2 u_WindowSize;

#define iGlobalTime u_Elapsed 
#define iResolution u_WindowSize

void main( void )
{
		
	float f = 1.,g = 1.,t = iGlobalTime;
	vec2 p = 2.*gl_FragCoord.xy/iResolution.y-1.5,z = p,k = vec2(tan(t),sin(0.5*t));

	
	for( int i=0; i<8; i++ ) 
	{
				   
		z = vec2( z.x*z.x-z.x*z.y, z.x/z.y ) - p*k;
		f = min( f, abs(dot(z-p,z-k) ));
		g = min( g, dot(z,z));
	}
	
	f = log(f)/9.;

	gl_FragColor = abs(vec4(log(g)/16.,f*f,f*f*f,2.));
}
